function [p_surv_idio, ai, available_data] = get_p_surv_idio3(dates, T, portfolio, y0, ajd_common_factor)
% --------------------------------------------------------------------------------------------------
% Calculate idiosyncratic survival probabilities of companies in portfolio, that is, calculate
% E(exp(\int_0^T -X_it dt))
% --------------------------------------------------------------------------------------------------
% dates             ... dates for which to compute future portfolio loss distribution
% T                 ... horizons for which to compute future portfolio loss distribution
% portfolio         ... portfolio of credit default swaps
% y0                ... initial intensity of common factor
% ajd_common_factor ... AJD dynamics of the common factor
% --------------------------------------------------------------------------------------------------
% sample call: get_p_surv_idio3(cdx_test.dates{1}, [1 5; 2 4], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics)
% --------------------------------------------------------------------------------------------------

% Allocate memory
num_dates = length(dates);
num_horizons = size(T,2);
num_firms = length(portfolio);
available_data = zeros(num_dates, num_firms);
ai = zeros(num_dates, num_firms);

if (0)  % Old version where X_i and Y_dynamics collapse to single AJD
    % Use AJD dynamics of (i) default intensity and (ii) common factor to infer AJD dynamics of
    % idiosyncratic factors (do the same for the initial default intensity)
    num_dates = length(dates);
    ajd_idiosyncratic = [];
    x0_idiosyncratic = zeros(num_dates, num_firms);
    ai = zeros(num_dates, num_firms);
    bi = ai;    
    %cds_liq_prem = zeros(num_dates, num_firms);
    for i=1:num_firms
        % Extract relevant dates for CDS & remember which data was available
        cds = portfolio(i);
        [available, pos] = is_member_sorted_c(dates, cds.dates{1});
        pos = pos(pos > 0);
        available = logical(available);
        available_data(:,i) = available;

        % Calculate implied dynamics of idionsyncratic risk factor
        if (~isfield(cds, 'bi'))
        	cds.bi = ones(length(cds.dates{1}));
        end
        if (length(cds.ai) > 1)
            ai(available,i) = cds.ai(pos);            
            bi(available,i) = cds.bi(pos);
        else
            ai(available,i) = cds.ai;
            bi(available,i) = cds.bi;        
        end
        %x0_idiosyncratic(available,i) = max(0, (cds.x0(pos) - y0(available) .* cds.ai(pos)));
        [ajd_temp, x0_tmp] = get_ajd_idio(cds, ajd_common_factor, dates, cds.x0, y0);
        x0_idiosyncratic(:,i) = x0_tmp;
        ajd_idiosyncratic = [ajd_idiosyncratic; ajd_temp];

        % Apply liquidity premium of tranches vs. index
        %cds_liq_prem(available,i) = liq_prem(available) .* cds.market_price{1}(pos) / 0.6;
    end
else
    % nothing to do
end

% Extract idiosyncratic survival probabilities for portfolio
p_surv_idio = NaN(num_dates, num_horizons, num_firms);
for j=1:num_firms
    if (0)
        % Old version where X_i and Y_dynamics collapse to single AJD
        [k, theta, sigma, L, mu] = generate_parameter_time_series(ajd_idiosyncratic(j), dates);
         % p_surv_idio(:,:,j) = surv_prob_c4(x0_idiosyncratic(:,j), k, theta, sigma, L, mu, T);
        for n=1:num_dates
            % p_surv_idio(n,:,j) = surv_prob_c4(x0_idiosyncratic(n,j), k(n), theta(n), sigma(n), L(n), mu(n), T(n,:));
            p_surv_idio(n,:,j) = mgf_intAJD2_c(x0_idiosyncratic(n,j), k(n), theta(n), sigma(n), L(n), mu(n), -bi(n,j), T(n,:));        
            if (max(p_surv_idio(n,:,j)) > 1)
                disp('Something wrong in get_p_surv_idio');
            end
        end
    else
        % Get parameter time series
        cds = portfolio(j);
        [k, theta, sigma, L, mu, x0] = generate_parameter_time_series(cds.AJD, dates, cds.x0);
        if isempty(k)
            continue;
        end
        used_cds_dates = cds.dates{1}(logical(is_member_sorted_c(cds.dates{1}, dates)));
        [trash, pos_cds, trash2, pos_all] = intersect_triple(cds.dates{1}, used_cds_dates, dates);  
        available_data(pos_all,j) = 1;
        ai(pos_all, j) = cds.ai(pos_cds); 
        if (~isfield(cds, 'bi'))
            cds.bi = ones(length(cds.dates{1}), 1);
        end
        bi = cds.bi(pos_cds);
        
        % Calculate survival probabilities
        for n=1:length(used_cds_dates)
            p_surv_idio(pos_all(n),:,j) = mgf_intAJD2_c(x0(n), k(n), theta(n), sigma(n), L(n), mu(n), -bi(n), T(pos_all(n),:));        
            if (max(p_surv_idio(pos_all(n),:,j)) > 1 + 1e-6)
                error('Something wrong in get_p_surv_idio');
            end
        end
    end
end
%disp(mean(x0_idiosyncratic, 2)*1e4);
%disp(mean(squeeze(p_surv_idio(2,end,:)))*1e4);
